#include <stdio.h>
#include <assert.h>
#include <vector>
#include <algorithm>

using namespace std;

vector <double> distanza;

void mappatura(int N, int X[], int Y[], int Z[]) {
    for (int i = 0; i < N; i++)
        distanza.push_back(sqrt((long long)X[i] * X[i] + (long long)Y[i] * Y[i] + (long long)Z[i] * Z[i]));
    sort(distanza.begin(), distanza.end());
}

int query(int D) {
    return upper_bound(distanza.begin(), distanza.end(), D) - distanza.begin();
}


#define MAXN 100000
int X[MAXN], Y[MAXN], Z[MAXN];

int main() {
    FILE *fr, *fw;
    int N, Q, i;

    fr = fopen("input.txt", "r");
    fw = fopen("output.txt", "w");
    assert(1 == fscanf(fr, "%d", &N));
    for(i=0; i<N; i++)
        assert(3 == fscanf(fr, "%d%d%d", &X[i], &Y[i], &Z[i]));

    mappatura(N, X, Y, Z);

    assert(1 == fscanf(fr, "%d", &Q));
    for(i=0; i<Q; i++) {
        int D;
        assert(1 == fscanf(fr, "%d", &D));
        fprintf(fw, "%d\n", query(D));
    }

    fclose(fr);
    fclose(fw);
    return 0;
}
