#include <algorithm>
#include <cmath>
#include <cstdio>
#include <vector>

using namespace std;

vector <double> distanza;

void mappatura(int N, int X[], int Y[], int Z[]) {
    for (int i = 0; i < N; i++)
        distanza.push_back(sqrt((long long)X[i] * X[i] +
                                (long long)Y[i] * Y[i] +
                                (long long)Z[i] * Z[i]));
    sort(distanza.begin(), distanza.end());
}

int query(int D) {
    return upper_bound(distanza.begin(), distanza.end(), D) - distanza.begin();
}


#define MAXN 100000
int X[MAXN], Y[MAXN], Z[MAXN];

int main()
{
    FILE *fr, *fw;
    int N, Q, i;

    fr = fopen("input.txt", "r");
    fw = fopen("output.txt", "w");
    fscanf(fr, "%d", &N);
    for(i=0; i<N; i++)
        fscanf(fr, "%d%d%d", &X[i], &Y[i], &Z[i]);

    mappatura(N, X, Y, Z);

    fscanf(fr, "%d", &Q);
    for(i=0; i<Q; i++)
    {
        int D;
        fscanf(fr, "%d", &D);
        fprintf(fw, "%d\n", query(D));
    }
    fclose(fr);
    fclose(fw);
    return 0;
}
