#include <fstream>
#include <list>

using namespace std;

#define MAXN 10000
#define MAXM 100000

int N, M, colori = 0;
list<int> grafo[MAXN];
bool visitato[MAXN];

void dfs(int nodo)
{
    visitato[nodo] = true;
    for (int adiacente: grafo[nodo])
        if (!visitato[adiacente])
            dfs(adiacente);
}

int main()
{
    ifstream in("input.txt");
    ofstream out("output.txt");
    in >> N >> M;
    for (int i = 0, a, b; i < M; i++)
    {
        in >> a >> b;
        grafo[a].push_back(b);
        grafo[b].push_back(a);
    }

    for (int i = 0; i < N; i++)
        if (!visitato[i])
        {
            colori++;
            dfs(i);
        }

    out << colori - 1 << endl;
}
