#include <algorithm>
#include <fstream>

#define MAXN 99

int N, vini[MAXN], din[MAXN];

using namespace std;

int main()
{
    ifstream in("input.txt");
    ofstream out("output.txt");
    in >> N;
    for (int i = 0; i < N; i++)
        in >> vini[i];
    // A partire dall'ultimo vino...
    for (int i = N - 1; i >= 0; i--) {
        // Calcola il vino migliore per proseguire tra tutti
        // quelli che vanno bene.
        int best = 0;
        for (int j = i + 2; j < N; j++)
            if (vini[j] >= vini[i])
                best = max(best, din[j]);
        // La più lunga sequenza a partire da questo vino è 1 più
        // la più lunga sequenza a partire dal miglior vino successivo.
        din[i] = best + 1;
    }
    // Stampa il miglior vino da cui iniziare
    out << *max_element(din, din + N) << endl;
}
