#include <algorithm>
#include <fstream>

#define MAXN 99

int N, vini[MAXN];
int best = 0;

using namespace std;

bool controlla(bool V[]) {
    // Controllo che la configurazione sia valida:
    // - se V[i] = 1, allora V[i + 1] non deve essere 1
    for (int i = 0; i < N - 1; i++)
        if (V[i] == true && V[i + 1] == true)
            return false;
    // - se V[i] = 1, allora per tutti i V[j] con j > i deve valere
    //   vini[j] >= vini[i]
    for (int i = 0; i < N; i++)
        if (V[i] == true)
            for (int j = i + 2; j < N; j++)
                if (V[j] == true && vini[j] < vini[i])
                    return false;

    // Se tutti i controlli sono stati superati, allora la configurazione
    // di V è valida.
    return true;
}

void genera_disposizioni(bool V[], int posizione)
{
    if (posizione == N)
    {
        if (controlla(V)) {
            // Conto vini
            int nvini = 0;
            for (int i = 0; i < N; i++)
                if (V[i] == true)
                    nvini++;
            // Aggiorno massimo
            best = max(best, nvini);
        }
    }
    else
    {
        V[posizione] = false;
        genera_disposizioni(V, posizione + 1);
        V[posizione] = true;
        genera_disposizioni(V, posizione + 1);
    }
}

int main()
{
    ifstream in("input.txt");
    ofstream out("output.txt");
    in >> N;
    for (int i = 0; i < N; i++)
        in >> vini[i];
    bool V[MAXN];
    genera_disposizioni(V, 0);
    out << best << endl;
}
