#include <stdio.h>
#include <stdlib.h>
#include <assert.h>
#include <string.h>
#include <vector>
#include <algorithm>
#include <utility>
#include <functional>

#define MAXN 20000
#define MAXM 20000

using namespace std;

int earn(int N, int M, int F[], char** T, char **S) {
    vector<pair<int, int> > plugs;
    int count_l10 = 0, count_l16 = 0, count_bi = 0;

    // Preprocess computers.
    for (int i = 0; i < N; i++)
        if (strcmp(T[i], "L10") == 0)
            plugs.push_back({F[i], 0});  // L10 -> type 0
        else if (strcmp(T[i], "L16") == 0)
            plugs.push_back({F[i], 1});  // L16 -> type 1

    // Preprocess sockets.
    for (int i = 0; i < M; i++) {
        if (strcmp(S[i], "L10") == 0)
            count_l10++;
        else if (strcmp(S[i], "L16") == 0)
            count_l16++;
        else
            count_bi++;
    }

    // Sort computers by decreasing F (the first element of the pair).
    sort(plugs.begin(), plugs.end(), greater<pair<int, int> >());

    int answer = 0;
    for (int i = 0; i < N; i++)
        if (plugs[i].second == 0) { // l10, look for l10 or bipasso
            if (count_l10 > 0) {
                count_l10--;
                answer += plugs[i].first;
            } else if (count_bi > 0) {
                count_bi--;
                answer += plugs[i].first;
            }
        } else { // l16, look for l16 or bipasso
            if (count_l16 > 0) {
                count_l16--;
                answer += plugs[i].first;
            } else if (count_bi > 0) {
                count_bi--;
                answer += plugs[i].first;
            }
        }

    return answer;
}


int F[MAXN];
char* T[MAXN];
char* S[MAXM];

int main() {
    FILE *fr, *fw;
    int N, M, i;

    fr = fopen("input.txt", "r");
    fw = fopen("output.txt", "w");
    assert(2 == fscanf(fr, "%d%d", &N, &M));
    for(i=0; i<N; i++)
        assert(1 == fscanf(fr, "%d", &F[i]));
    for(i=0; i<N; i++) {
        T[i] = (char*) malloc(16 * sizeof(char*));
        assert(1 == fscanf(fr, "%s", T[i]));
    }
    for(i=0; i<M; i++) {
        S[i] = (char*) malloc(16 * sizeof(char*));
        assert(1 == fscanf(fr, "%s", S[i]));
    }

    fprintf(fw, "%d\n", earn(N, M, F, T, S));
    fclose(fr);
    fclose(fw);
    return 0;
}
